<?php

class SiteController extends Controller
{
	const BROWSCAP_CACHE = 'protected/runtime/browscap';

	public function actionGetLinks()
	{
		$links = array(
			'baseUrl'=>Yii::app()->baseUrl,
			'studentAjaxLogin'=>$this->createUrl('/student/main/ajaxLogin'),
			'studentAjaxRegister'=>$this->createUrl('/student/main/ajaxRegister'),
			'studentAjaxPassword'=>$this->createUrl('/student/main/ajaxPassword'),
			'studentAjaxInfoDialog'=>$this->createUrl('/student/main/ajaxInfoDialog'),
			'studentAjaxInfoSubmit'=>$this->createUrl('/student/main/ajaxInfoSubmit'),
			'studentAjaxGetFirstAction'=>$this->createUrl('/student/main/ajaxGetFirstAction'),
			'studentAjaxGetChildAction'=>$this->createUrl('/student/main/ajaxGetChildAction'),
			'studentAjaxIsLoggedIn'=>$this->createUrl('/student/main/ajaxIsLoggedIn'),
			'studentAjaxIsRegistrationEnabled'=>$this->createUrl('/student/main/ajaxIsRegistrationEnabled'),
			'studentAjaxGetCurrentLesson'=>$this->createUrl('/student/main/ajaxGetCurrentLesson'),
			'studentAjaxGetAllowedInteriors'=>$this->createUrl('/student/main/ajaxGetAllowedInteriors'),
			'studentAjaxGetUserData'=>$this->createUrl('/student/main/ajaxGetUserData'),
			'studentAjaxGetNewsheadlinesData'=>$this->createUrl('/student/main/ajaxGetNewsheadlinesData'),
			'studentAjaxGetStudentActionData'=>$this->createUrl('/student/main/ajaxGetStudentActionData'),
			'studentAjaxFiles'=>$this->createUrl('/student/main/ajaxFiles'),
			'studentAjaxGetDialogue'=>$this->createUrl('/student/main/ajaxGetDialogue'),
			'studentAjaxForm1'=>$this->createUrl('/student/main/ajaxForm', array('id'=>1)),
			'studentAjaxForm2'=>$this->createUrl('/student/main/ajaxForm', array('id'=>2)),
			'studentAjaxForm3'=>$this->createUrl('/student/main/ajaxForm', array('id'=>3)),
			'studentAjaxForm4'=>$this->createUrl('/student/main/ajaxForm', array('id'=>4)),
			'studentAjaxForm5'=>$this->createUrl('/student/main/ajaxForm', array('id'=>5)),
			'studentAjaxForm6'=>$this->createUrl('/student/main/ajaxForm', array('id'=>6)),
			'studentAjaxForm7'=>$this->createUrl('/student/main/ajaxForm', array('id'=>7)),
			'studentAjaxForm8'=>$this->createUrl('/student/main/ajaxForm', array('id'=>8)),
			'studentAjaxForm9'=>$this->createUrl('/student/main/ajaxForm', array('id'=>9)),
			'studentAjaxForm10'=>$this->createUrl('/student/main/ajaxForm', array('id'=>10)),
			'studentAjaxForm11'=>$this->createUrl('/student/main/ajaxForm', array('id'=>11)),
			'studentAjaxForm'=>$this->createUrl('/student/main/ajaxForm', array('id'=>'ajax_form_id_template')),
			'studentAjaxAboutDialog'=>$this->createUrl('/student/main/ajaxAboutDialog'),
			'studentAjaxInteriorHTML'=>$this->createUrl('/student/main/ajaxInteriorHTML'),
			'studentAjaxBiuroDialog'=>$this->createUrl('/student/main/ajaxBiuroDialog'),
			'studentAjaxMakeTransfer'=>$this->createUrl('/student/bank/ajaxMakeTransfer'),
			'studentAjaxFireWorker'=>$this->createUrl('/student/actions/ajaxFireWorker'),
			'studentAjaxSubmitTask'=>$this->createUrl('/student/tasks/ajaxSubmitTask'),
			'studentAjaxBeginTask'=>$this->createUrl('/student/tasks/ajaxBeginTask'),
			'studentInvoice'=>$this->createUrl('/student/main/invoice', array('id' => '_INVOICE_ID_')),
			'studentBooknote'=>$this->createUrl('/student/main/bookNote', array('id' => '_BOOKNOTE_ID_')),
			'studentAjaxGetTrainingMaterials'=>$this->createUrl('/student/actions/ajaxGetTrainingMaterials'),
			'studentAjaxStartExam'=>$this->createUrl('/student/actions/ajaxStartExam'),
			'studentAjaxExamAnswerQuestion'=>$this->createUrl('/student/actions/ajaxExamAnswerQuestion'),
			'studentAjaxSubmitExam'=>$this->createUrl('/student/actions/ajaxSubmitExam'),
			'studentAjaxRecruitWorker'=>$this->createUrl('/student/actions/ajaxRecruitWorker'),
			'studentAjaxAvileableWorkers'=>$this->createUrl('/student/main/ajaxAvileableWorkers'),
			'studentAjaxSubmitAnswer'=>$this->createUrl('/student/tasks/ajaxSubmitAnswer'),
			'studentAjaxFetchOrders'=>$this->createUrl('/student/tasks/ajaxFetchOrders'),
			'studentAjaxFetchTasks'=>$this->createUrl('/student/tasks/ajaxFetchTasks'),
			'studentAjaxTakeTask'=>$this->createUrl('/student/tasks/ajaxTakeTask'),
			'studentAjaxTakeOrder'=>$this->createUrl('/student/tasks/ajaxTakeOrder'),
			'studentAjaxGetCompaniesToTender'=>$this->createUrl('/student/tasks/ajaxGetCompaniesToTender'),
			'studentAjaxAdAgencyBuyLogo'=>$this->createUrl('/student/adAgency/ajaxBuyLogo'),
			'studentAjaxBuyCampaing'=>$this->createUrl('/student/adAgency/ajaxBuyCampaing'),
			'studentAjaxSelectBank'=>$this->createUrl('/student/bank/ajaxSelectBank'),
			'studentAjaxMessageMarkRead'=>$this->createUrl('/student/actions/ajaxMessageMarkRead'),
			'studentAjaxAcceptOrderInvitation'=>$this->createUrl('/student/tasks/ajaxAcceptOrderInvitation'),
			'studentAjaxAssignTask'=>$this->createUrl('/student/tasks/assignTask'),
			'studentAjaxMarkStudentPresence'=>$this->createUrl('/student/actions/markStudentPresence'),
			'studentAjaxIsFormAccepted'=>$this->createUrl('/student/main/ajaxIsFormAccepted'),
			'studentAjaxGetFormStatus'=>$this->createUrl('/student/main/ajaxGetFormStatus'),
			'studentAjaxSaveSpecificFormData'=>$this->createUrl('/student/main/ajaxSaveSpecificFormData'),
			'studentAjaxFetchBonusTasks'=>$this->createUrl('/student/tasks/fetchBonusTasks'),
			'studentAjaxSimTaskAssign'=>$this->createUrl('/student/tasks/simulateTaskAssignment'),
			'studentAjaxGetCompanyBank'=>$this->createUrl('/student/main/ajaxGetCompanyBank'),
			'studentAjaxIsBlockedAction'=>$this->createUrl('/student/main/ajaxIsBlockedAction'),
			'studentAjaxGetInfoStrings'=>$this->createUrl('/student/main/ajaxGetInfoStrings'),
			'studentModuleBankrut' => Yii::app()->getModule('student')->getAssetsUrl() . '/js/gui/gui-bankrut.js',
			'studentAjaxGenerateRandomPESEL'=>$this->createUrl('/student/main/ajaxGenerateRandomPESEL'),
			'studentAjaxGenerateRandomNIP'=>$this->createUrl('/student/main/ajaxGenerateRandomNIP'),
			'studentAjaxGenerateRandomREGON'=>$this->createUrl('/student/main/ajaxGenerateRandomREGON'),
			'studentAjaxPullMissedForms'=>$this->createUrl('/student/main/ajaxPullMissedForms'),
			'studentAjaxMakeDonationTransfer'=>$this->createUrl('/student/bank/ajaxMakeDonationTransfer'),
			'studentAjaxGetOfficesData'=>$this->createUrl('/student/main/ajaxGetOfficesData'),
			'studentAjaxGetBusinessInfo'=>$this->createUrl('/student/main/ajaxGetBusinessInfo'),
			'studentAjaxIsFormSent'=>$this->createUrl('/student/main/ajaxIsFormSent'),
			'studentAjaxMakeVatTransfer'=>$this->createUrl('/student/bank/ajaxMakeVatTransfer'),
			'studentAjaxGetTime'=>$this->createUrl('/student/main/ajaxGetTime'),
			'studentAjaxRemoveZalegleOplaty'=>$this->createUrl('/student/main/ajaxRemoveZalegleOplaty'),
			'studentAjaxCalculateVat'=>$this->createUrl('/student/main/ajaxCalculateVat'),
			'studentAjaxFillZusDra'=>$this->createUrl('/student/main/ajaxFillZusDra'),
			'studentAjaxFillZusRca'=>$this->createUrl('/student/main/ajaxFillZusRca'),
			'studentAjaxPit36'=>$this->createUrl('/student/main/ajaxPit36'),
			'studentAssetsUrl'=>Yii::app()->getModule('student')->getAssetsUrl(),
		);

		header('Content-Type: application/javascript');
		echo 'window.links = '.CJavaScript::encode($links).';';
	}

	/**
	 * This is the default 'index' action that is invoked
	 * when an action is not explicitly requested by users.
	 */
	public function actionIndex()
	{
/*
		Yii::import('ext.phpbrowscap.Browscap', true);

		$agent = filter_input(INPUT_SERVER, 'HTTP_USER_AGENT', FILTER_SANITIZE_STRING);
		$powiadomienie = false;

		if (!file_exists(self::BROWSCAP_CACHE))
			mkdir(self::BROWSCAP_CACHE, 0777, true);
		$bc = new \phpbrowscap\Browscap(self::BROWSCAP_CACHE);
		$browser = $bc->getBrowser($agent);
		//Yii::log($agent);
		//Yii::log(serialize($browser));
		//echo '<div style="visibility: hidden">'.print_r($browser).'</div>';
*/
		$browser = null;

		$messages = Akcja::model()->findAll(array(    //'"idRodzica" is null AND
			//'condition' => '"idLekcji" > 0',
			'order' => '"idLekcji" ASC'));
		$text = ParametryGry::model()->find('"nazwa" = \'TEXT_PO_LEKCJI\'');
		$textFirst = ParametryGry::model()->find('"nazwa" = \'TEXT_PO_PIERWSZYCH_LEKCJACH\'');
		$messageArray = array();
		$messageArray[-1]= Akcja::parseText($textFirst->wartosc);
		$messageArray[0] = Akcja::parseText($text->wartosc);

		$tematPo = ParametryGry::model()->find('"nazwa" = \'TEMAT_PO_LEKCJI\'');
		$topicArray = array();
		$topicArray[-1] = Akcja::parseText($tematPo->wartosc);
		$topicArray[0] = Akcja::parseText($tematPo->wartosc);

		//$i = 1;
		foreach ($messages as $msg)
		{
			$messageArray[$msg->id] = Akcja::parseText($msg->tresc);
			if(isset($msg->naglowek))
			{
				$topicArray[$msg->id] = Akcja::parseText($msg->naglowek);
			}
			//$i++;
		}

		// quick hack - debug lesson(-1) was breaking it
		$text2 = Akcja::model()->find(array('condition' => '"idRodzica" is null AND "idLekcji" = 1'));
		$messageArray[1] = Akcja::parseText($text2->tresc);
		$topicArray[1] = Akcja::parseText($text2->naglowek);

		//$this->render('index', array('messages' => $messageArray, 'topics' => $topicArray));


//		 USER AGENT NIEPOPRAWNIE WYKRYWANY DLA WINDOWS8 pod Chrome/Firefox
		// zakomentowane do poprawy
//		if (isset($browser->Browser) && in_array(strtolower($browser->Browser), array('chrome', 'firefox')))	//spróbuj wykryc przez broswcap
//			$this->render('index', array('messages' => $messageArray, 'topics' => $topicArray));
//		else if (preg_match('/(trident\/[0-9]{1,2}.[0-9]{1,2})|(msie [0-9]{1,2}.[0-9]{1,2})/i', $agent))	//nigdy nie pozwalaj na ie                   //stare warunki
//			$this->render('indexUnsupportedBrowser', array('messages' => $messageArray, 'topics' => $topicArray));
//		else if (preg_match('/Mozilla\/5\.0.*(?=Firefox\/[0-9]{1,2})/i', $agent)) //TODO: najnowszy firefox jest niewykrywany
//			$this->render('index', array('messages' => $messageArray, 'topics' => $topicArray));
//		else
//			$this->render('indexUnsupportedBrowser', array('messages' => $messageArray, 'topics' => $topicArray));
//
/*
		// ### NOWE WARUNKI ##//
		if (isset($browser->Browser)){
			if(!isset($browser->RenderingEngine_Name)) {
					$browser->RenderingEngine_Name="Empty";
			}

			if($browser->RenderingEngine_Name=='Trident'||$browser->RenderingEngine_Name=='Unknown'||$browser->RenderingEngine_Name==''){
					$this->render('indexUnsupportedBrowser', array('messages' => $messageArray, 'topics' => $topicArray)); // wykryto jakies IE lub nieznany engine
			}
			elseif($browser->RenderingEngine_Name=='Gecko'||$browser->Browser=='Firefox'){ //sprawdzenie czy to firefox
				if((int)($browser->Version)<17){   //sprawdzic od korej wersji firefoxa nie dziala (w 3.6 napewno nie dziala)
						$this->render('indexUnsupportedBrowser', array('messages' => $messageArray, 'topics' => $topicArray)); //wykryto stary firefox
				}
				else {
						$powiadomienie = true;
						$this->render('index', array('messages' => $messageArray, 'topics' => $topicArray, 'powiadomienie' => $powiadomienie));  //wykryto najnowszy firefox // wyswietlic powiedomienie w divie
				}
			}
			elseif(($browser->RenderingEngine_Name=='WebKit'||$browser->RenderingEngine_Name=='Blink')&&($browser->Browser=='Chrome'||$browser->Browser=='Chromium')) //sprawdzenie czy to chrome
			{
				if((int)($browser->Version)<28){   //sprawdzic czy w starych wersjach chrome dziala
						$powiadomienie = true;
					$this->render('index', array('messages' => $messageArray, 'topics' => $topicArray, 'powiadomienie' => $powiadomienie));//wykryto stary chrome // powiadomienie ?
				}
				else {
					$this->render('index', array('messages' => $messageArray, 'topics' => $topicArray)); //wykryto najnowszy chrome
				}
			}
			elseif($browser->RenderingEngine_Name=='WebKit'||$browser->RenderingEngine_Name=='Blink')
			{
				$powiadomienie = true;
				$this->render('index', array('messages' => $messageArray, 'topics' => $topicArray, 'powiadomienie' => $powiadomienie)); //przegladarka z tym silnikiem powinna sobie poradzic z gra ale wyswietlic powiadomienie
			}
			else
			{
				$this->render('indexUnsupportedBrowser', array('messages' => $messageArray, 'topics' => $topicArray)); //nieznana przeglądarka sprawdzić czy dziala to pod windows 8
			}
		}
		// ### NOWE WARUNKI END ##//
		*/

		// najnowsze detect
		if (strpos($_SERVER['HTTP_USER_AGENT'], 'Chrome') !== false
 		 || strpos($_SERVER['HTTP_USER_AGENT'], 'CriOS') !== false 
 		 || strpos($_SERVER['HTTP_USER_AGENT'], 'Chromium') !== false) 
 		 {
			$this->render('index', array('messages' => $messageArray, 'topics' => $topicArray)); //wykryto najnowszy chrome
 		 }
 		 else
 		 {
			$this->render('indexUnsupportedBrowser', array('messages' => $messageArray, 'topics' => $topicArray)); //nieznana przeglądarka sprawdzić czy dziala to pod windows 8
 		 }
	}
	
	public function actionForce()
	{
		$messages = Akcja::model()->findAll(array(    //'"idRodzica" is null AND
			//'condition' => '"idLekcji" > 0',
			'order' => '"idLekcji" ASC'));
		$text = ParametryGry::model()->find('"nazwa" = \'TEXT_PO_LEKCJI\'');
		$textFirst = ParametryGry::model()->find('"nazwa" = \'TEXT_PO_PIERWSZYCH_LEKCJACH\'');
		$messageArray = array();
		$messageArray[-1] = Akcja::parseText($textFirst->wartosc);
		$messageArray[0] = Akcja::parseText($text->wartosc);

		$tematPo = ParametryGry::model()->find('"nazwa" = \'TEMAT_PO_LEKCJI\'');
		$topicArray = array();
		$topicArray[-1] = Akcja::parseText($tematPo->wartosc);
		$topicArray[0] = Akcja::parseText($tematPo->wartosc);

		//$i = 1;
		foreach ($messages as $msg)
		{
			$messageArray[$msg->id] = Akcja::parseText($msg->tresc);
			if(isset($msg->naglowek))
			{
				$topicArray[$msg->id] = Akcja::parseText($msg->naglowek);
			}
			//$i++;
		}

		// quick hack - debug lesson(-1) was breaking it
		$text2 = Akcja::model()->find(array('condition' => '"idRodzica" is null AND "idLekcji" = 1'));
		$messageArray[1] = Akcja::parseText($text2->tresc);
		$topicArray[1] = Akcja::parseText($text2->naglowek);

		$this->render('index', array('messages' => $messageArray, 'topics' => $topicArray));
	}

	/**
	 * This is the action to handle external exceptions.
	 */
	public function actionError()
	{
		if($error = Yii::app()->errorHandler->error)
		{
			if(Yii::app()->request->isAjaxRequest)
				echo $error['message'];
			else
				$this->render('error', $error);
		}
	}
}
